#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "compiler.h"
#include "capi.h"
#include "9188e.h"

#define CHAT_PORT 10000
#define BUF_SIZE 200

static char rgcKeyBuf[BUF_SIZE];//for editing
static NET_ADDR sNetAddr; //general use

/*
Creates a human understandible string from a Sockets error code

Argument:
	uErrCode - The sockets error code

Returns:
	A pointer to the (static) string representation of the error
*/
char *Err(unsigned uErrCode)
{
	static char rgcUnk[30];
	static char *rgszErrs[] =
	{
		"NoErr",
		"InUse",
		"DOSErr",
		"NoMem",
		"NotNetconn",
		"IllegalOp",
		"BadPkt",
		"NoHost",
		"CantOpen",
		"NetUnreachable",
		"HostUnreachable",
		"ProtUnreachable",
		"PortUnreachable",
		"TimeOut",
		"HostUnknown",
		"NoServers",
		"ServerErr",
		"BadFormat",
		"BadArg",
		"EOF",
		"Reset",
		"WouldBlock",
		"UnBound",
		"NoDesc",
		"BadSysCall",
		"CantBroadcast",
		"NotEstab",
		"ReEntry",
	};

	if (uErrCode == ERR_API_NOT_LOADED)
		return "Sockets API not loaded";
	if ((uErrCode & 0xff) > ERR_RE_ENTRY)
	{
		sprintf(rgcUnk,"Unknown error 0x%04X",uErrCode);
		return rgcUnk;
	}
	return rgszErrs[uErrCode & 0xff];
}

/*
Get a socket descriptor that can be used to send UDP packets

Returns: A descriptor of the socket, or 0 if an error occured. (Returns 
immediately) */ 
static int GetClientSock(void) { int iSock;
	memset(&sNetAddr, 0, sizeof(NET_ADDR));
	sNetAddr.wRemotePort = CHAT_PORT;

	if ((iSock = GetSocket()) < 0)
		printf("Error on GetSocket(): %s\n",Err(iNetErrNo));
	else if (SetSocketOption(iSock, 0, NET_OPT_NON_BLOCKING, 1, 1) < 0)
		printf("Error on setOpt(): %s\n",Err(iNetErrNo));
	else if (ConnectSocket(iSock, DATA_GRAM, &sNetAddr) < 0)
		printf("Error on net_connect: %s\n",Err(iNetErrNo));
	else
	{
		printf("Client sock successfully created\n");
		return iSock;
	}

	return 0;
}
/*
Start a UDP server on specified port.

Returns:
	A descriptor of the server socket, or 0 if an error occured.
	(Returns immediately)

*/
int StartListen(int iPort)
{
	int iServSock;	//the new socket

	memset(&sNetAddr, 0, sizeof(NET_ADDR));
	sNetAddr.wLocalPort = iPort;

	if ((iServSock = GetSocket()) < 0)
		printf("Error on serv GetSocket(): %s\n",Err(iNetErrNo));
	else if (SetSocketOption(iServSock, 0, NET_OPT_NON_BLOCKING, 1, 1) < 0)
		printf("Error on serv setOpt(): %s\n", Err(iNetErrNo));
	else if (ListenSocket(iServSock, DATA_GRAM, &sNetAddr) < 0)
		printf("Error on serv net_listen: %s\n", Err(iNetErrNo));
	else
	{
		printf("Server sock successfully created\n");
		return iServSock;
	}
	return 0;
}

/*
Create a string representation of the IP address and port, in the form
	a.b.c.d:port, eg 196.10.180.3:1400.
Max length is 22 bytes.

Arguments:
	psAddr - pointer to NET_ADDR structure containing address of host.

Returns:
	Pointer to (static) array containing null-terminated string.
*/
static char *WriteName(NET_ADDR *psAddr)
{
	static char rgcName[22];

	sprintf(rgcName, "%u.%u.%u.%u:%u",
		((BYTE *)&psAddr->dwRemoteHost)[0],
		((BYTE *)&psAddr->dwRemoteHost)[1],
		((BYTE *)&psAddr->dwRemoteHost)[2],
		((BYTE *)&psAddr->dwRemoteHost)[3],
		psAddr->wRemotePort
	);
	return rgcName;
}

void main(void)
{
	int iSendSock;		//socket for sending packets

	printf("Sockets UDP Demo: Transmit \n");

	//start to listen for datagrams
	iSendSock = GetClientSock();
	if (iSendSock == 0)
		return;

	printf("Enter to transmit, CTRL-X to exit.\n");
	while (1)
	{
		gets(rgcKeyBuf);
		if (rgcKeyBuf[0]==24){
			ReleaseSocket(iSendSock);
			return;
		} else {
			if (WriteSocket(iSendSock, rgcKeyBuf, strlen(rgcKeyBuf), NET_FLG_BROADCAST) < 0)//error
				printf("Error on NetWrite %d bytes: %s\n", strlen(rgcKeyBuf), Err(iNetErrNo));
		} 
	}
}
